
Imports System
Imports System.Data
Imports System.Data.OleDb

Public Class frmMain
  Inherits System.Windows.Forms.Form

  Private Const MAX_RECORDS As Integer = 10000

  Private RecordsRead As Long

  Private strConnect As String
  Private MyTable As String
  Private MyDataSet As New DataSet()

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call

  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.IContainer

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  Friend WithEvents btnExit As System.Windows.Forms.Button
  Friend WithEvents OleDbConnection1 As System.Data.OleDb.OleDbConnection
  Friend WithEvents OleDbDataAdapter1 As System.Data.OleDb.OleDbDataAdapter
  Friend WithEvents OpenFileDialog1 As System.Windows.Forms.OpenFileDialog
  Friend WithEvents Panel1 As System.Windows.Forms.Panel
  Friend WithEvents txtFirstName As System.Windows.Forms.TextBox
  Friend WithEvents Label4 As System.Windows.Forms.Label
  Friend WithEvents Label5 As System.Windows.Forms.Label
  Friend WithEvents txtLastName As System.Windows.Forms.TextBox
  Friend WithEvents Label6 As System.Windows.Forms.Label
  Friend WithEvents txtCompany As System.Windows.Forms.TextBox
  Friend WithEvents Label7 As System.Windows.Forms.Label
  Friend WithEvents txtAddress As System.Windows.Forms.TextBox
  Friend WithEvents Label8 As System.Windows.Forms.Label
  Friend WithEvents txtCity As System.Windows.Forms.TextBox
  Friend WithEvents Label9 As System.Windows.Forms.Label
  Friend WithEvents txtState As System.Windows.Forms.TextBox
  Friend WithEvents Label10 As System.Windows.Forms.Label
  Friend WithEvents txtZip As System.Windows.Forms.TextBox
  Friend WithEvents btnFirst As System.Windows.Forms.Button
  Friend WithEvents btnNext As System.Windows.Forms.Button
  Friend WithEvents btnPrevious As System.Windows.Forms.Button
  Friend WithEvents btnLast As System.Windows.Forms.Button
  Friend WithEvents gbxDBNavigation As System.Windows.Forms.GroupBox
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.btnExit = New System.Windows.Forms.Button()
    Me.OleDbConnection1 = New System.Data.OleDb.OleDbConnection()
    Me.OleDbDataAdapter1 = New System.Data.OleDb.OleDbDataAdapter()
    Me.OpenFileDialog1 = New System.Windows.Forms.OpenFileDialog()
    Me.Panel1 = New System.Windows.Forms.Panel()
    Me.Label10 = New System.Windows.Forms.Label()
    Me.txtZip = New System.Windows.Forms.TextBox()
    Me.Label9 = New System.Windows.Forms.Label()
    Me.txtState = New System.Windows.Forms.TextBox()
    Me.Label8 = New System.Windows.Forms.Label()
    Me.txtCity = New System.Windows.Forms.TextBox()
    Me.Label7 = New System.Windows.Forms.Label()
    Me.txtAddress = New System.Windows.Forms.TextBox()
    Me.Label6 = New System.Windows.Forms.Label()
    Me.txtCompany = New System.Windows.Forms.TextBox()
    Me.Label5 = New System.Windows.Forms.Label()
    Me.txtLastName = New System.Windows.Forms.TextBox()
    Me.Label4 = New System.Windows.Forms.Label()
    Me.txtFirstName = New System.Windows.Forms.TextBox()
    Me.gbxDBNavigation = New System.Windows.Forms.GroupBox()
    Me.btnLast = New System.Windows.Forms.Button()
    Me.btnPrevious = New System.Windows.Forms.Button()
    Me.btnNext = New System.Windows.Forms.Button()
    Me.btnFirst = New System.Windows.Forms.Button()
    Me.Panel1.SuspendLayout()
    Me.gbxDBNavigation.SuspendLayout()
    Me.SuspendLayout()
    '
    'btnExit
    '
    Me.btnExit.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.btnExit.Location = New System.Drawing.Point(424, 168)
    Me.btnExit.Name = "btnExit"
    Me.btnExit.Size = New System.Drawing.Size(88, 24)
    Me.btnExit.TabIndex = 5
    Me.btnExit.Text = "E&xit"
    '
    'OpenFileDialog1
    '
    Me.OpenFileDialog1.CheckFileExists = False
    Me.OpenFileDialog1.CheckPathExists = False
    '
    'Panel1
    '
    Me.Panel1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
    Me.Panel1.Controls.AddRange(New System.Windows.Forms.Control() {Me.Label10, Me.txtZip, Me.Label9, Me.txtState, Me.Label8, Me.txtCity, Me.Label7, Me.txtAddress, Me.Label6, Me.txtCompany, Me.Label5, Me.txtLastName, Me.Label4, Me.txtFirstName})
    Me.Panel1.Location = New System.Drawing.Point(8, 8)
    Me.Panel1.Name = "Panel1"
    Me.Panel1.Size = New System.Drawing.Size(392, 112)
    Me.Panel1.TabIndex = 17
    '
    'Label10
    '
    Me.Label10.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
    Me.Label10.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.Label10.Location = New System.Drawing.Point(296, 80)
    Me.Label10.Name = "Label10"
    Me.Label10.Size = New System.Drawing.Size(32, 20)
    Me.Label10.TabIndex = 30
    Me.Label10.Text = "Zip: "
    Me.Label10.TextAlign = System.Drawing.ContentAlignment.MiddleRight
    '
    'txtZip
    '
    Me.txtZip.Location = New System.Drawing.Point(328, 80)
    Me.txtZip.Name = "txtZip"
    Me.txtZip.Size = New System.Drawing.Size(48, 20)
    Me.txtZip.TabIndex = 29
    Me.txtZip.Text = "TextBox1"
    '
    'Label9
    '
    Me.Label9.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
    Me.Label9.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.Label9.Location = New System.Drawing.Point(184, 80)
    Me.Label9.Name = "Label9"
    Me.Label9.Size = New System.Drawing.Size(56, 20)
    Me.Label9.TabIndex = 28
    Me.Label9.Text = "State:"
    Me.Label9.TextAlign = System.Drawing.ContentAlignment.MiddleRight
    '
    'txtState
    '
    Me.txtState.Location = New System.Drawing.Point(240, 80)
    Me.txtState.Name = "txtState"
    Me.txtState.Size = New System.Drawing.Size(56, 20)
    Me.txtState.TabIndex = 27
    Me.txtState.Text = "TextBox1"
    '
    'Label8
    '
    Me.Label8.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
    Me.Label8.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.Label8.Location = New System.Drawing.Point(8, 80)
    Me.Label8.Name = "Label8"
    Me.Label8.Size = New System.Drawing.Size(72, 20)
    Me.Label8.TabIndex = 26
    Me.Label8.Text = "First Name: "
    Me.Label8.TextAlign = System.Drawing.ContentAlignment.MiddleRight
    '
    'txtCity
    '
    Me.txtCity.Location = New System.Drawing.Point(80, 80)
    Me.txtCity.Name = "txtCity"
    Me.txtCity.Size = New System.Drawing.Size(112, 20)
    Me.txtCity.TabIndex = 25
    Me.txtCity.Text = "TextBox1"
    '
    'Label7
    '
    Me.Label7.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
    Me.Label7.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.Label7.Location = New System.Drawing.Point(8, 56)
    Me.Label7.Name = "Label7"
    Me.Label7.Size = New System.Drawing.Size(72, 20)
    Me.Label7.TabIndex = 24
    Me.Label7.Text = "Address: "
    Me.Label7.TextAlign = System.Drawing.ContentAlignment.MiddleRight
    '
    'txtAddress
    '
    Me.txtAddress.Location = New System.Drawing.Point(80, 56)
    Me.txtAddress.Name = "txtAddress"
    Me.txtAddress.Size = New System.Drawing.Size(296, 20)
    Me.txtAddress.TabIndex = 23
    Me.txtAddress.Text = "TextBox1"
    '
    'Label6
    '
    Me.Label6.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
    Me.Label6.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.Label6.Location = New System.Drawing.Point(8, 8)
    Me.Label6.Name = "Label6"
    Me.Label6.Size = New System.Drawing.Size(72, 20)
    Me.Label6.TabIndex = 22
    Me.Label6.Text = "Company: "
    Me.Label6.TextAlign = System.Drawing.ContentAlignment.MiddleRight
    '
    'txtCompany
    '
    Me.txtCompany.Location = New System.Drawing.Point(80, 8)
    Me.txtCompany.Name = "txtCompany"
    Me.txtCompany.Size = New System.Drawing.Size(296, 20)
    Me.txtCompany.TabIndex = 21
    Me.txtCompany.Text = "TextBox1"
    '
    'Label5
    '
    Me.Label5.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
    Me.Label5.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.Label5.Location = New System.Drawing.Point(192, 32)
    Me.Label5.Name = "Label5"
    Me.Label5.Size = New System.Drawing.Size(72, 20)
    Me.Label5.TabIndex = 20
    Me.Label5.Text = "Last Name: "
    Me.Label5.TextAlign = System.Drawing.ContentAlignment.MiddleRight
    '
    'txtLastName
    '
    Me.txtLastName.Location = New System.Drawing.Point(264, 32)
    Me.txtLastName.Name = "txtLastName"
    Me.txtLastName.Size = New System.Drawing.Size(112, 20)
    Me.txtLastName.TabIndex = 19
    Me.txtLastName.Text = "TextBox1"
    '
    'Label4
    '
    Me.Label4.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
    Me.Label4.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.Label4.Location = New System.Drawing.Point(8, 32)
    Me.Label4.Name = "Label4"
    Me.Label4.Size = New System.Drawing.Size(72, 20)
    Me.Label4.TabIndex = 18
    Me.Label4.Text = "First Name: "
    Me.Label4.TextAlign = System.Drawing.ContentAlignment.MiddleRight
    '
    'txtFirstName
    '
    Me.txtFirstName.Location = New System.Drawing.Point(80, 32)
    Me.txtFirstName.Name = "txtFirstName"
    Me.txtFirstName.Size = New System.Drawing.Size(112, 20)
    Me.txtFirstName.TabIndex = 17
    Me.txtFirstName.Text = "TextBox1"
    '
    'gbxDBNavigation
    '
    Me.gbxDBNavigation.Controls.AddRange(New System.Windows.Forms.Control() {Me.btnLast, Me.btnPrevious, Me.btnNext, Me.btnFirst})
    Me.gbxDBNavigation.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.gbxDBNavigation.Location = New System.Drawing.Point(8, 128)
    Me.gbxDBNavigation.Name = "gbxDBNavigation"
    Me.gbxDBNavigation.Size = New System.Drawing.Size(392, 64)
    Me.gbxDBNavigation.TabIndex = 18
    Me.gbxDBNavigation.TabStop = False
    Me.gbxDBNavigation.Text = "Database Navigation:"
    '
    'btnLast
    '
    Me.btnLast.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.btnLast.Location = New System.Drawing.Point(296, 24)
    Me.btnLast.Name = "btnLast"
    Me.btnLast.Size = New System.Drawing.Size(88, 24)
    Me.btnLast.TabIndex = 9
    Me.btnLast.Text = "&Last"
    '
    'btnPrevious
    '
    Me.btnPrevious.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.btnPrevious.Location = New System.Drawing.Point(200, 24)
    Me.btnPrevious.Name = "btnPrevious"
    Me.btnPrevious.Size = New System.Drawing.Size(88, 24)
    Me.btnPrevious.TabIndex = 8
    Me.btnPrevious.Text = "&Previous"
    '
    'btnNext
    '
    Me.btnNext.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.btnNext.Location = New System.Drawing.Point(104, 24)
    Me.btnNext.Name = "btnNext"
    Me.btnNext.Size = New System.Drawing.Size(88, 24)
    Me.btnNext.TabIndex = 7
    Me.btnNext.Text = "&Next"
    '
    'btnFirst
    '
    Me.btnFirst.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.btnFirst.Location = New System.Drawing.Point(8, 24)
    Me.btnFirst.Name = "btnFirst"
    Me.btnFirst.Size = New System.Drawing.Size(88, 24)
    Me.btnFirst.TabIndex = 6
    Me.btnFirst.Text = "&First"
    '
    'frmMain
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(520, 213)
    Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.gbxDBNavigation, Me.Panel1, Me.btnExit})
    Me.Name = "frmMain"
    Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
    Me.Text = "Database Navigation"
    Me.Panel1.ResumeLayout(False)
    Me.gbxDBNavigation.ResumeLayout(False)
    Me.ResumeLayout(False)

  End Sub

#End Region

  Private Function GetFileName() As String
    ' Purpose:  This function attempts to open an Access database
    '
    ' Argument list:
    '   none
    '
    ' Return value
    '   string      the name of the file selected or an empty 
    '               string if cancelled.
    '
    Dim NewFileName As String
    Dim NewFile As OpenFileDialog = New OpenFileDialog()
    Dim MyChoice As DialogResult

    With NewFile
      .Filter = "Access Files (*.mdb)|*.mdb|All Files (*.*)|*.*"
      .FilterIndex = 1                      ' Assume text files
      .DefaultExt = "mdb"                   ' Ditto
      .InitialDirectory = "D:\VSNET\Crystal Reports\Samples\Database\"
      .CheckFileExists = False
      .ReadOnlyChecked = True
      .Title = "Open Access Data File"
    End With

    MyChoice = NewFile.ShowDialog           ' What did they do?

    If MyChoice = DialogResult.Cancel Then  ' Bail out?
      NewFileName = ""
    Else
      NewFileName = NewFile.FileName
    End If

    If NewFileName.Length > 0 Then
      Return NewFileName
    End If
  End Function

  Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
    ' Purpose:  This opens and reads in the table names from the database.
    Dim FileName, SQL As String

    FileName = GetFileName()            ' Get the database file name
    If FileName.Length = 0 Then
      Exit Sub
    End If
    Me.Text = "DB Navigation: " & FileName ' Show the file name

    ' This builds the connect string. It is used later as needed, too.
    strConnect = "Provider=Microsoft.Jet.OLEDB.4.0;Password="""";User ID=Admin;Data Source="
    strConnect &= FileName
    MyTable = "Customer"
    Dim Connect As New OleDbConnection(strConnect) ' Reuse connect string...
    Connect.Open()                            ' ...and reopen the connection
    SQL = "SELECT * FROM Customer"
    Dim MyAdapter As New OleDbDataAdapter(SQL, Connect)

    Try
      ' How many records were returned?
      RecordsRead = MyAdapter.Fill(MyDataSet, 0, MAX_RECORDS, MyTable)
      Connect.Close()                                     ' Close it down
      SetControlBindings()
      MyAdapter = Nothing           ' Free things up
      Connect = Nothing
    Catch
      MessageBox.Show("Something wrong during connecting.")
    End Try
    WhichRecord()

  End Sub

  Private Sub btnExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExit.Click
    Me.Dispose()
  End Sub

  Private Sub SetControlBindings()
    txtCompany.DataBindings.Add("Text", MyDataSet, "Customer.Customer Name")
    txtFirstName.DataBindings.Add("Text", MyDataSet, "Customer.Contact First Name")
    txtLastName.DataBindings.Add("Text", MyDataSet, "Customer.Contact Last Name")
    txtAddress.DataBindings.Add("Text", MyDataSet, "Customer.Address1")
    txtCity.DataBindings.Add("Text", MyDataSet, "Customer.City")
    txtState.DataBindings.Add("Text", MyDataSet, "Customer.Region")
    txtZip.DataBindings.Add("Text", MyDataSet, "Customer.Postal Code")
  End Sub

  Private Sub btnFirst_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnFirst.Click
    Me.BindingContext(MyDataSet, MyTable).Position = 0
    WhichRecord()
  End Sub

  Private Sub btnNext_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNext.Click
    Me.BindingContext(MyDataSet, MyTable).Position += 1
    WhichRecord()
  End Sub

  Private Sub btnPrevious_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPrevious.Click
    Me.BindingContext(MyDataSet, MyTable).Position -= 1
    WhichRecord()
  End Sub

  Private Sub btnLast_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnLast.Click
    Me.BindingContext(MyDataSet, MyTable).Position = RecordsRead - 1
    WhichRecord()
  End Sub

  Private Sub WhichRecord()
    ' Purpose:  This finds out which record we are looking at and updates
    '           the groupbox text property with the record number.
    Dim where As Long

    where = Me.BindingContext(MyDataSet, MyTable).Position + 1
    gbxDBNavigation.Text = "Navigate Database: Record # " & CStr(where)

  End Sub

End Class